/***************************************************************************/
/**                                                                       **/
/**                               MAGICARD                                **/
/**                                                                       **/
/***************************************************************************/
/**                                                                       **/
/**  PROJECT      : SDK C# Demo - DTC Printers                            **/
/**                                                                       **/
/**  MODULE NAME  : Info.cs                                               **/
/**                                                                       **/
/**  COPYRIGHT    : Magicard                                              **/
/**                                                                       **/
/***************************************************************************/
using System;
using System.Text;
using System.Windows.Forms;
using System.Collections.Generic;
using SDKShim;

namespace CSharpDemo
{
    public partial class SDK_CSDemo : Form
    {
        #region === Local Methods ===

        private void InitInfoTab()
        {
            InitPasswordCombo();
        }

        private void ClearMsgBoxButton_Click(object sender, EventArgs e)
        {
            InfoMsgBox.Clear();
        }

        #endregion === Local Methods ===

        //----------------------------------------------------------------------

        #region === Printer Status ===

        private void PrinterStatusButton_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;

            string msg;
            switch (SDK.ID_PrinterStatus(hSession))
            {
            case SDK.PrinterStatus.Ready:   msg = "Printer is READY";       break;
            case SDK.PrinterStatus.Offline: msg = "Printer is OFFLINE";     break;
            case SDK.PrinterStatus.Error:   msg = "Printer is in ERROR";    break;
            default:                        msg = "Unknown Printer Status"; break;
            }
            InfoMsgBox.AppendText(msg + Environment.NewLine);
            InfoMsgBox.AppendText(Environment.NewLine);

            Cursor.Current = Cursors.Default;
        }

        #endregion === Printer Status ===

        //----------------------------------------------------------------------

        #region === Printer Info ===

        private void PrinterInfoButton_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;

            SDK.PrinterInfo PrinterInfo = new SDK.PrinterInfo();
            SDK.Return SDKReturn = SDK.ID_PrinterInfo(hSession, PrinterInfo);
            if (SDKReturn != SDK.Return.Success)
            {
                HandleError("PrinterInfo", SDKReturn);
            }
            else
            {
                InfoMsgBox.AppendText("PrinterConnected: " + PrinterInfo.bPrinterConnected + Environment.NewLine);
                InfoMsgBox.AppendText("Model No.: "        + PrinterInfo.eModel + Environment.NewLine);
                InfoMsgBox.AppendText("Model: "            + PrinterInfo.sModel + Environment.NewLine);
                InfoMsgBox.AppendText("PrinterSerial: "    + PrinterInfo.sPrinterSerial + Environment.NewLine);
                InfoMsgBox.AppendText("PrintheadSerial: "  + PrinterInfo.sPrintheadSerial + Environment.NewLine);
                InfoMsgBox.AppendText("PCBSerial: "        + PrinterInfo.sPCBSerial + Environment.NewLine);
                InfoMsgBox.AppendText("FirmwareVersion: "  + PrinterInfo.Firmware.Version + Environment.NewLine);

                InfoMsgBox.AppendText("Printhead: ");
                switch (PrinterInfo.ePrintheadType)
                {
                case 0: InfoMsgBox.AppendText("KGE2"     + Environment.NewLine); break;
                case 1: InfoMsgBox.AppendText("KEE1"     + Environment.NewLine); break;
                case 2: InfoMsgBox.AppendText("KEE4"     + Environment.NewLine); break;
                default: InfoMsgBox.AppendText("Unknown" + Environment.NewLine); break;
                }

                InfoMsgBox.AppendText("Density: "            + PrinterInfo.iDensity + Environment.NewLine);
                InfoMsgBox.AppendText("HandFeed: "
                                      + handfeedkp[(PrinterInfo.iHandFeed != 0) ? SDK.HandFeed.On : SDK.HandFeed.Off]
                                      + Environment.NewLine);
                InfoMsgBox.AppendText("CardsPrinted: "        + PrinterInfo.iCardsPrinted + Environment.NewLine);
                InfoMsgBox.AppendText("CardsOnPrinthead: "    + PrinterInfo.iCardsOnPrinthead + Environment.NewLine);
                InfoMsgBox.AppendText("DyePanelsPrinted: "    + PrinterInfo.iDyePanelsPrinted + Environment.NewLine);
                InfoMsgBox.AppendText("CleansSinceShipped: "  + PrinterInfo.iCleansSinceShipped + Environment.NewLine);
                InfoMsgBox.AppendText("DyePanelsSinceClean: " + PrinterInfo.iDyePanelsSinceClean + Environment.NewLine);
                InfoMsgBox.AppendText("CardsSinceClean: "     + PrinterInfo.iCardsSinceClean + Environment.NewLine);
                InfoMsgBox.AppendText("CardsBetweenCleans: "  + PrinterInfo.iCardsBetweenCleans + Environment.NewLine);

                InfoMsgBox.AppendText("PrintHeadPosn: "       + PrinterInfo.iPrintHeadPosn + Environment.NewLine);
                InfoMsgBox.AppendText("ImageStartPosn: "      + PrinterInfo.iImageStartPosn + Environment.NewLine);
                InfoMsgBox.AppendText("ImageEndPosn: "        + PrinterInfo.iImageEndPosn + Environment.NewLine);
                InfoMsgBox.AppendText("MajorError: "          + PrinterInfo.iMajorError + Environment.NewLine);
                InfoMsgBox.AppendText("MinorError: "          + PrinterInfo.iMinorError + Environment.NewLine);

                InfoMsgBox.AppendText("TagUID: "              + PrinterInfo.sTagUID + Environment.NewLine);
                InfoMsgBox.AppendText("ShotsOnFilm: "         + PrinterInfo.iShotsOnFilm + Environment.NewLine);
                InfoMsgBox.AppendText("ShotsUsed: "           + PrinterInfo.iShotsUsed + Environment.NewLine);
                InfoMsgBox.AppendText("DyeFilmType: "         + PrinterInfo.sDyeFilmType + Environment.NewLine);
                InfoMsgBox.AppendText("DyeFilmManuf: "        + PrinterInfo.eDyeFilmManuf + Environment.NewLine);
                InfoMsgBox.AppendText("ColourLength: "        + PrinterInfo.iColourLength + Environment.NewLine);
                InfoMsgBox.AppendText("ResinLength: "         + PrinterInfo.iResinLength + Environment.NewLine);
                InfoMsgBox.AppendText("OvercoatLength: "      + PrinterInfo.iOvercoatLength + Environment.NewLine);
                InfoMsgBox.AppendText("DyeFlags: "            + PrinterInfo.eDyeFlags + Environment.NewLine);
                InfoMsgBox.AppendText("CommandCode: "         + PrinterInfo.iCommandCode + Environment.NewLine);
                InfoMsgBox.AppendText("DOB: "                 + PrinterInfo.iDOB + Environment.NewLine);
                InfoMsgBox.AppendText("DyeFilmProg: "         + PrinterInfo.eDyeFilmProg + Environment.NewLine);

                String temp_string;
                if (PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.EncodePlaten))
                    temp_string = smartmodekp[SDK.SmartMode.Platen];
                else if (PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.EncodeXLI))
                    temp_string = smartmodekp[SDK.SmartMode.XLI];
                else
                    temp_string = smartmodekp[SDK.SmartMode.Default];
                InfoMsgBox.AppendText("SmartMode: " + temp_string + Environment.NewLine);

                InfoMsgBox.AppendText("SmartOffset: " + PrinterInfo.iSmartOffset + Environment.NewLine);

                if (PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.EjectMode))
                    temp_string = ejectmodekp[SDK.EjectMode.On];
                else
                    temp_string = ejectmodekp[SDK.EjectMode.Off];
                InfoMsgBox.AppendText("EjectMode: " + temp_string + Environment.NewLine);

                if (PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.HorzEject))
                    temp_string = horzejectkp[SDK.HorzEject.On];
                else
                    temp_string = horzejectkp[SDK.HorzEject.Off];
                InfoMsgBox.AppendText("HorzEject: " + temp_string + Environment.NewLine);

                if (PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.EraseSpeed))
                    temp_string = erasespeedkp[SDK.EraseSpeed.Quick];
                else
                    temp_string = erasespeedkp[SDK.EraseSpeed.Thorough];
                InfoMsgBox.AppendText("EraseSpeed: " + temp_string + Environment.NewLine + Environment.NewLine);
            }

            Cursor.Current = Cursors.Default;
        }

        #endregion === Printer Info ===

        //----------------------------------------------------------------------

        #region === SDK Version ===
        
        private void SDKVersionButton_Click(object sender, EventArgs e)
        {
            SDK.SDKVersion SDKVersion = new SDK.SDKVersion();

            SDK.Return SDKReturn = SDK.ID_SDKVersion(hSession, SDKVersion);
            if (SDKReturn != SDK.Return.Success)
            {
                HandleError("SDKVersion", SDKReturn);
            }
            else
            {
                InfoMsgBox.AppendText("Version: " + SDKVersion.Major
                                      + "."       + SDKVersion.Minor
                                      + "."       + SDKVersion.Build
                                      + "."       + SDKVersion.Private
                                      + Environment.NewLine);
                InfoMsgBox.AppendText(Environment.NewLine);
            }
        }

        #endregion === SDK Version ===

        //----------------------------------------------------------------------

        #region === Connection Type ===

        private void ConnectionTypeButton_Click(object sender, EventArgs e)
        {
            string msg;
            switch (SDK.ID_ConnectionType(hSession))
            {
            case SDK.ConnectionType.USB:      msg = "USB";      break;
            case SDK.ConnectionType.Ethernet: msg = "Ethernet"; break;
            case SDK.ConnectionType.File:     msg = "File";     break;
            default:                          msg = "Unknown";  break;
            }
            InfoMsgBox.AppendText("Connection Type: " + msg + Environment.NewLine);
            InfoMsgBox.AppendText(Environment.NewLine);
        }

        #endregion === Connection Type ===

        //----------------------------------------------------------------------

        #region === Printer Type ===

        private void PrinterTypeButton_Click(object sender, EventArgs e)
        {
            InfoMsgBox.AppendText("Printer Type - ");
            switch (SDK.ID_PrinterType(hSession))
            {
            case SDK.PrinterType.Rio:
                InfoMsgBox.AppendText("RioTango" + Environment.NewLine);
                break;
            case SDK.PrinterType.AOTA:
                InfoMsgBox.AppendText("AOTA" + Environment.NewLine);
                break;
            case SDK.PrinterType.Enduro:
                InfoMsgBox.AppendText("Enduro Family" + Environment.NewLine);
                break;
            case SDK.PrinterType.Ultima:
                InfoMsgBox.AppendText("Ultima" + Environment.NewLine);
                break;
            case SDK.PrinterType.Generation2:
                InfoMsgBox.AppendText("Generation 2 Family" + Environment.NewLine);
                break;
            default:
                InfoMsgBox.AppendText("UNKNOWN" + Environment.NewLine);
                break;
            }
            InfoMsgBox.AppendText(Environment.NewLine);
        }

        #endregion === Printer Type ===

        //----------------------------------------------------------------------

        #region === Printer Model ===

        private void PrinterModelButton_Click(object sender, EventArgs e)
        {
            string msg;
            SDK.Model model = SDK.ID_PrinterModel(hSession);
            if (model.HasFlag(SDK.Model.Pronto))           msg = "Pronto";
            else if (model.HasFlag(SDK.Model.RioPro))      msg = "Rio Pro";
            else if (model.HasFlag(SDK.Model.Ultima))      msg = "Ultima";
            else if (model.HasFlag(SDK.Model.Enduro))      msg = "Enduro";
            else if (model.HasFlag(SDK.Model.RioPro360))   msg = "Rio Pro 360";
            else if (model.HasFlag(SDK.Model.Model600))    msg = "600";
            else if (model.HasFlag(SDK.Model.Model300))    msg = "300";
            else if (model.HasFlag(SDK.Model.Pronto100))   msg = "Pronto 100";
            else if (model.HasFlag(SDK.Model.Generation2)) msg = "Generation 2";
            else msg = "Unknown";
            InfoMsgBox.AppendText("Printer Model - " + msg + Environment.NewLine);

            InfoMsgBox.AppendText("Capability:" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_Magnetic))    InfoMsgBox.AppendText("  - Mag Encoding" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_Duplex))      InfoMsgBox.AppendText("  - Duplex" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_Rewrite))     InfoMsgBox.AppendText("  - Rewrite" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_Chip))        InfoMsgBox.AppendText("  - Chip Encoding" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_Contactless)) InfoMsgBox.AppendText("  - Contactless Encoding" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_Extended))    InfoMsgBox.AppendText("  - Extended" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_Ethernet))    InfoMsgBox.AppendText("  - Ethernet" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_Laminate))    InfoMsgBox.AppendText("  - Laminator" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_600dpi))      InfoMsgBox.AppendText("  - 600dpi" + Environment.NewLine);

            InfoMsgBox.AppendText(Environment.NewLine);
        }

        #endregion === Printer Model ===

        //----------------------------------------------------------------------

        #region === SDK Bits ===

        private void SDKBitsButton_Click(object sender, EventArgs e)
        {
            InfoMsgBox.AppendText(SDK.ID_SDKBits() + " Bit SDK" + Environment.NewLine + Environment.NewLine);
        }

        #endregion === SDK Bits ===

        //----------------------------------------------------------------------

        #region === Password ===

        private void PasswordCombo_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (((KeyValuePair<SDK.Password, string>)PwdCommandCombo.SelectedItem).Key == SDK.Password.Use)
            {
                Pwd2Label.Enabled = false;
                Password2.Enabled      = false;
            }
            else
            {
                Pwd2Label.Enabled = true;
                Password2.Enabled      = true;
            }
        }

        Dictionary<SDK.Password, string> passwordcmdkp = new Dictionary<SDK.Password, string>()
        {
            {SDK.Password.Set, "Set"},
            {SDK.Password.Use, "Use"},
        };

        private void InitPasswordCombo()
        {
            PwdCommandCombo.DataSource    = new BindingSource(passwordcmdkp, null);
            PwdCommandCombo.DisplayMember = "Value";
            PwdCommandCombo.SelectedItem  = SDK.Password.Set;
        }

        private void PasswordButton_Click(object sender, EventArgs e)
        {
            SDK.Password PasswordCmd = ((KeyValuePair<SDK.Password, string>)PwdCommandCombo.SelectedItem).Key;

            SDK.Return SDKReturn = SDK.ID_Password(hSession, PasswordCmd, Password1.Text, Password2.Text);
            if (SDKReturn != SDK.Return.Success)
            {
                HandleError("Password", SDKReturn);
            }
        }

        #endregion === Password ===

        //----------------------------------------------------------------------

        #region === Last Message ===

        private void LastMessageButton_Click(object sender, EventArgs e)
        {
            StringBuilder Temp = new StringBuilder();
            SDK.Return SDKReturn = SDK.ID_LastMessage(hSession, Temp);
            if (SDKReturn != SDK.Return.Success)
            {
                HandleError("GetLastMessage", SDKReturn);
            }
            else
            {
                foreach (char c in Temp.ToString())
                {
                    InfoMsgBox.AppendText(c == '\n' ? Environment.NewLine : c.ToString());
                }
                InfoMsgBox.AppendText(Environment.NewLine);
                InfoMsgBox.AppendText(Environment.NewLine);
            }
        }

        #endregion === Last Message ===

        //----------------------------------------------------------------------

        #region === Pro360 Parameters ===

        private enum ParamType { AsBool, AsInt, AsString };

        private struct ParamSet
        {
            public string          Text;
	        public SDK.Pro360Param ID;
            public ParamType       Type;

            public ParamSet(string x, SDK.Pro360Param y, ParamType z)
            {
                Text = x;
                ID   = y;
                Type = z;
            }
        };

        IList<ParamSet> paramTable = new List<ParamSet> { 
	        new ParamSet("Duplex",				         SDK.Pro360Param.CapabilityDuplex,			ParamType.AsBool), 
	        new ParamSet("Mag Encoding",		         SDK.Pro360Param.CapabilityMag,				ParamType.AsBool), 
	        new ParamSet("Smart Encoding",		         SDK.Pro360Param.CapabilitySmart,			ParamType.AsBool), 
	        new ParamSet("System Version",		         SDK.Pro360Param.SystemVersion,				ParamType.AsString), 
	        new ParamSet("Printer App Version",	         SDK.Pro360Param.PrinterAppVersion,			ParamType.AsString), 
	        new ParamSet("Firmware Version",	         SDK.Pro360Param.FirmwareVersion,			ParamType.AsString), 
	        new ParamSet("Mag Firmware Version",         SDK.Pro360Param.MagFirmwareVersion,		ParamType.AsString), 
	        new ParamSet("Printer Serial",		         SDK.Pro360Param.PrinterSerial,				ParamType.AsString), 
	        new ParamSet("Printhead Serial",	         SDK.Pro360Param.PrintheadSerial,			ParamType.AsString), 
	        new ParamSet("Main Board Serial",	         SDK.Pro360Param.BoardSerial,				ParamType.AsString), 
	        new ParamSet("Model Name",			         SDK.Pro360Param.ModelName,					ParamType.AsString), 
	        new ParamSet("Dealer Code",			         SDK.Pro360Param.DealerCode,			    ParamType.AsInt), 
	        new ParamSet("Project Code",		         SDK.Pro360Param.ProjectCode,		        ParamType.AsInt), 
	        new ParamSet("Total Cards",			         SDK.Pro360Param.TotalCards,			    ParamType.AsInt), 
	        new ParamSet("Total Panels",		         SDK.Pro360Param.TotalPanels,			    ParamType.AsInt), 
	        new ParamSet("Cards on Printhead",	         SDK.Pro360Param.CardsOnPrinthead,		    ParamType.AsInt), 
	        new ParamSet("Panels on Printhead",	         SDK.Pro360Param.PanelsOnPrinthead,		    ParamType.AsInt), 
	        new ParamSet("Cards since Clean",	         SDK.Pro360Param.CardsSinceClean,		    ParamType.AsInt), 
	        new ParamSet("Panels since Clean",	         SDK.Pro360Param.PanelsSinceClean,	        ParamType.AsInt), 
	        new ParamSet("Cleaning Cycles",		         SDK.Pro360Param.Cleans,				    ParamType.AsInt), 
	        new ParamSet("Dyefilm Name",		         SDK.Pro360Param.DyeFilmName,				ParamType.AsString), 
	        new ParamSet("Dyefilm Serial",		         SDK.Pro360Param.DyeFilmSerial,				ParamType.AsString), 
	        new ParamSet("Dyefilm Prints",		         SDK.Pro360Param.DyeFilmTotalPrints,		ParamType.AsInt), 
	        new ParamSet("Dyefilm Prints Left",	         SDK.Pro360Param.DyeFilmPrintsRemaining,    ParamType.AsInt), 
	        new ParamSet("Dyefilm Manufacturer",         SDK.Pro360Param.DyeFilmManufacturer,		ParamType.AsInt), 
	        new ParamSet("Dyefilm YMC Length",	         SDK.Pro360Param.ColourLength,				ParamType.AsInt), 
	        new ParamSet("Dyefilm K Length",	         SDK.Pro360Param.BlackLength,				ParamType.AsInt), 
	        new ParamSet("Dyefilm O Length",	         SDK.Pro360Param.OverlayLength,				ParamType.AsInt), 
	        new ParamSet("Cards between Cleans",         SDK.Pro360Param.CleansInterval,		    ParamType.AsInt), 
	        new ParamSet("Clean Overdue",		         SDK.Pro360Param.CleanOverdue,				ParamType.AsBool), 
	        new ParamSet("MAC Address",			         SDK.Pro360Param.MACAddress,				ParamType.AsString), 
	        new ParamSet("Use DHCP",			         SDK.Pro360Param.UseDHCP,				    ParamType.AsBool), 
	        new ParamSet("IP Address",			         SDK.Pro360Param.DynamicIPAddress,			ParamType.AsString), 
	        new ParamSet("IP Gateway",			         SDK.Pro360Param.DynamicGateway,			ParamType.AsString), 
	        new ParamSet("IP Subnet",			         SDK.Pro360Param.DynamicSubnet,				ParamType.AsString), 
	        new ParamSet("Static IP Address",	         SDK.Pro360Param.StaticIPAddress,			ParamType.AsString), 
	        new ParamSet("Static IP Gateway",	         SDK.Pro360Param.StaticGateway,			    ParamType.AsString), 
	        new ParamSet("Static IP Subnet",	         SDK.Pro360Param.StaticSubnet,			    ParamType.AsString), 
	        new ParamSet("Error Status",		         SDK.Pro360Param.ErrorCode,					ParamType.AsString), 
	        new ParamSet("Hand Feed",			         SDK.Pro360Param.HandFeed,					ParamType.AsBool), 
	        new ParamSet("Card Position",		         SDK.Pro360Param.CardLocation,				ParamType.AsString), 
	        new ParamSet("Mag Encoding Start",	         SDK.Pro360Param.MagStart,					ParamType.AsInt), 
	        new ParamSet("Contactless Offset",	         SDK.Pro360Param.SmartOffset,				ParamType.AsInt), 
	        new ParamSet("HoloKote Slots",               SDK.Pro360Param.HoloKoteCount,				ParamType.AsInt), 
	        new ParamSet("600 dpi",                      SDK.Pro360Param.Resolution600dpi,			ParamType.AsBool), 
	        new ParamSet("Hopper Sensor",                SDK.Pro360Param.SensorHopper,				ParamType.AsBool), 
	        new ParamSet("Exit Sensor",                  SDK.Pro360Param.SensorExit,				ParamType.AsBool), 
	        new ParamSet("Lid Sensor",                   SDK.Pro360Param.SensorLid,				    ParamType.AsBool), 
            new ParamSet("Manufacturer",                 SDK.Pro360Param.Manufacturer,				ParamType.AsString), 
            new ParamSet("Hopper Sensor Fitted",         SDK.Pro360Param.HopperSensorFitted,		ParamType.AsBool), 
            new ParamSet("Exit Sensor Fitted",           SDK.Pro360Param.ExitSensorFitted,			ParamType.AsBool), 
            new ParamSet("Region",                       SDK.Pro360Param.Region,				    ParamType.AsInt), 
            new ParamSet("WiFi Static IP Address",       SDK.Pro360Param.WifiStaticIP,              ParamType.AsString),
            new ParamSet("WiFi Static IP Gateway",       SDK.Pro360Param.WifiStaticGateway,         ParamType.AsString),
            new ParamSet("WiFi Static IP Subnet",        SDK.Pro360Param.WifiStaticSubnet,          ParamType.AsString),
            new ParamSet("WiFi MAC Address",             SDK.Pro360Param.WifiMACAddress,            ParamType.AsString),
            new ParamSet("WiFi Use DHCP",                SDK.Pro360Param.WifiUseDHCP,               ParamType.AsBool),
            new ParamSet("WiFi IP Address",              SDK.Pro360Param.WifiDynamicIPAddress,      ParamType.AsString),
            new ParamSet("WiFi IP Gateway",              SDK.Pro360Param.WifiDynamicGateway,        ParamType.AsString),
            new ParamSet("WiFi IP Subnet",               SDK.Pro360Param.WifiDynamicSubnet,         ParamType.AsString),
            new ParamSet("Power Standby Timeout",        SDK.Pro360Param.PowerStandbyTimeout,       ParamType.AsInt),
            new ParamSet("Power Off Timeout",            SDK.Pro360Param.PowerOffTimeout,           ParamType.AsInt),
            new ParamSet("Static Nameserver 1",          SDK.Pro360Param.NetStaticNameserver1,      ParamType.AsString),
            new ParamSet("Static Nameserver 2",          SDK.Pro360Param.NetStaticNameserver2,      ParamType.AsString),
            new ParamSet("WiFi Static Nameserver 1",     SDK.Pro360Param.WifiStaticNameserver1,     ParamType.AsString),
            new ParamSet("WiFi Static Nameserver 2",     SDK.Pro360Param.WifiStaticNameserver2,     ParamType.AsString),
            new ParamSet("Network Hostname",             SDK.Pro360Param.NetHostname,               ParamType.AsString),
            new ParamSet("Web UI",                       SDK.Pro360Param.CapabilityWebUI,           ParamType.AsBool),
            new ParamSet("Access Level",                 SDK.Pro360Param.AccessLevel,               ParamType.AsString),
            new ParamSet("WiFi",                         SDK.Pro360Param.CapabilityWifi,            ParamType.AsBool),
            new ParamSet("ADC Dye Sensor",               SDK.Pro360Param.SensorADCDye,              ParamType.AsInt),
            new ParamSet("ADC Current Sensor",           SDK.Pro360Param.SensorADCCurrent,          ParamType.AsInt),
            new ParamSet("Opto Encoder In Sensor",       SDK.Pro360Param.SensorOptoEncIn,           ParamType.AsInt),
            new ParamSet("Opto Encoder Out Sensor",      SDK.Pro360Param.SensorOptoEncOut,          ParamType.AsInt),
            new ParamSet("Opto Cam Sensor",              SDK.Pro360Param.SensorOptoCam,             ParamType.AsInt),
            new ParamSet("Opto Front Sensor",            SDK.Pro360Param.SensorOptoFront,           ParamType.AsInt),
            new ParamSet("Opto Mid Sensor",              SDK.Pro360Param.SensorOptoMid,             ParamType.AsInt),
            new ParamSet("Opto Rear Sensor",             SDK.Pro360Param.SensorOptoRear,            ParamType.AsInt),
            new ParamSet("Opto Flip Sensor",             SDK.Pro360Param.SensorOptoFlip,            ParamType.AsInt),
            new ParamSet("Dye Position Sensor",          SDK.Pro360Param.SensorPositionDye,         ParamType.AsInt),
            new ParamSet("Printhead Temperature Sensor", SDK.Pro360Param.SensorPrintheadTemp,       ParamType.AsInt),
            new ParamSet("Dye Motor Events Sensor",      SDK.Pro360Param.SensorDyeMotorEvents,      ParamType.AsInt),
            new ParamSet("WiFi Network List",            SDK.Pro360Param.WifiNetworkList,           ParamType.AsString),
            new ParamSet("WiFi Network",                 SDK.Pro360Param.WifiNetwork,               ParamType.AsString),
            new ParamSet("UI Language",                  SDK.Pro360Param.UILanguage,                ParamType.AsString),
            new ParamSet("Clean From Rear",              SDK.Pro360Param.CleanFromRear,             ParamType.AsBool),
            new ParamSet("Web UI Enabled",               SDK.Pro360Param.WebUIEnabled,              ParamType.AsBool),
            new ParamSet("Dye Ribbon Detected",          SDK.Pro360Param.DyeRibbonDetected,         ParamType.AsBool),
            new ParamSet("WiFi Dongle Connected",        SDK.Pro360Param.WifiDongleConnected,       ParamType.AsBool),
            new ParamSet("WiFi Connection Status",       SDK.Pro360Param.WifiConnectionStatus,      ParamType.AsString),
            new ParamSet("Eject Direction",              SDK.Pro360Param.EjectDirection,            ParamType.AsInt),
            new ParamSet("Eject Speed",                  SDK.Pro360Param.EjectSpeed,                ParamType.AsInt),
            new ParamSet("Eject Distance",               SDK.Pro360Param.EjectDistance,             ParamType.AsInt),
            new ParamSet("Reject Direction",             SDK.Pro360Param.RejectDirection,           ParamType.AsInt),
            new ParamSet("Reject Speed",                 SDK.Pro360Param.RejectSpeed,               ParamType.AsInt),
            new ParamSet("Reject Distance",              SDK.Pro360Param.RejectDistance,            ParamType.AsInt),
        };

        private void ReadParamButton_Click(object sender, EventArgs e)
        {
            SDK.Return SDKReturn;
            string tempString = "";
            ParamSet param = paramTable[ParamCombo.SelectedIndex];

            switch (param.Type)
            {
            case ParamType.AsInt:
                int tempint = new int();
                SDKReturn = SDK.ID_AccessInt(hSession, SDK.Action.Read, param.ID, ref tempint);
                tempString = tempint.ToString();
                break;

            case ParamType.AsBool:
                bool tempbool = new bool();
                SDKReturn = SDK.ID_AccessBool(hSession, SDK.Action.Read, param.ID, ref tempbool);
                tempString = tempbool ? "TRUE" : "FALSE";
                break;

            default:
                StringBuilder tempsb = new StringBuilder();
                SDKReturn = SDK.ID_AccessString(hSession, SDK.Action.Read, param.ID, tempsb);
                tempString = tempsb.ToString();
                break;
            }

            if (SDKReturn != SDK.Return.Success)
            {
                HandleError("GetParam", SDKReturn); 
            }
            else
            {
                InfoMsgBox.AppendText(param.Text 
                                      + Separator(SDK.Action.Read) 
                                      + tempString
                                      + Environment.NewLine);
                InfoMsgBox.AppendText(Environment.NewLine);
            }
        }

        #endregion === Pro360 Parameters ===

        //----------------------------------------------------------------------

        #region === Pro360 All Params ===

        private void AllParamsButton_Click(object sender, EventArgs e)
        {
            SDK.Return SDKReturn;
            string tempString = "";
            foreach (ParamSet p in paramTable)
            {
                switch (p.Type)
                {
                case ParamType.AsInt:
                    int tempint = new int();
                    SDKReturn = SDK.ID_AccessInt(hSession, SDK.Action.Read, p.ID, ref tempint);
                    tempString = tempint.ToString();
                    break;

                case ParamType.AsBool:
                    bool tempbool = new bool();
                    SDKReturn = SDK.ID_AccessBool(hSession, SDK.Action.Read, p.ID, ref tempbool);
                    tempString = tempbool ? "TRUE" : "FALSE";
                    break;

                default:
                    StringBuilder tempsb = new StringBuilder();
                    SDKReturn = SDK.ID_AccessString(hSession, SDK.Action.Read, p.ID, tempsb);
                    tempString = tempsb.ToString();
                    break;
                }

                if (SDKReturn != SDK.Return.Success)
                {
                    HandleError("GetAllParam", SDKReturn); 
                }
                else
                {
                    InfoMsgBox.AppendText(p.Text 
                                          + Separator(SDK.Action.Read) 
                                          + tempString
                                          + Environment.NewLine);
                }
            }
            InfoMsgBox.AppendText(Environment.NewLine);
        }

        #endregion === Pro360 All Params ===

        //----------------------------------------------------------------------

        #region === Sensors ===

        private void SensorsButton_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor; 
            
            SDK.Sensors response = 0;
            SDK.Return SDKReturn = SDK.ID_Sensors(hSession, ref response);
            if (SDKReturn != SDK.Return.Success)
            {
                HandleError("Sensors", SDKReturn); 
            }
            else
            {
                InfoMsgBox.AppendText("Sensors:" + Environment.NewLine);
                if (response.HasFlag(SDK.Sensors.Lid))
                    InfoMsgBox.AppendText("- Lid Closed" + Environment.NewLine);
                else
                    InfoMsgBox.AppendText("- Lid Open" + Environment.NewLine);

                if (response.HasFlag(SDK.Sensors.HopperValid))
                    InfoMsgBox.AppendText("- Hopper Sensor Not Fitted\n" + Environment.NewLine);
                if (response.HasFlag(SDK.Sensors.Hopper))
                    InfoMsgBox.AppendText("- Cards in Hopper" + Environment.NewLine);
                else
                    InfoMsgBox.AppendText("- Cards Low" + Environment.NewLine);

                if (response.HasFlag(SDK.Sensors.ExitValid))
                    InfoMsgBox.AppendText("- Exit Sensor Not Fitted\n");
                else if (response.HasFlag(SDK.Sensors.Exit))
                    InfoMsgBox.AppendText("- Exit Blocked" + Environment.NewLine);
                else
                    InfoMsgBox.AppendText("- Exit Clear");

                InfoMsgBox.AppendText(Environment.NewLine);
            }
            
            Cursor.Current = Cursors.Default;
        }

        #endregion === Sensors ===

    }
}
